/*
 * Decompiled with CFR 0.152.
 */
package me.ultrusmods.missingwilds.resource;

import me.ultrusmods.missingwilds.Constants;
import me.ultrusmods.missingwilds.compat.ForgeModCompatHandler;
import me.ultrusmods.missingwilds.data.LogData;
import me.ultrusmods.missingwilds.platform.Services;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagBuilder;
import net.minecraft.tags.TagEntry;
import pers.solid.brrp.v1.RRPEventHelper;
import pers.solid.brrp.v1.api.RuntimeResourcePack;
import pers.solid.brrp.v1.model.ModelJsonBuilder;

public class MissingWildsForgeResources {
    public static final RuntimeResourcePack RESOURCE_PACK = RuntimeResourcePack.create((ResourceLocation)Constants.id("resources"));
    public static final TagBuilder FALLEN_LOGS = TagBuilder.m_215899_();

    public static void registerPack() {
        RRPEventHelper.BEFORE_VANILLA.registerPack(RESOURCE_PACK);
    }

    public static void generatePack() {
        ForgeModCompatHandler.modCompats.values().forEach(modCompat -> modCompat.logs().forEach(logEither -> {
            LogData logData = logEither.left().isPresent() ? ForgeModCompatHandler.getSimpleLogName((String)logEither.left().get(), modCompat.modid()) : (LogData)logEither.right().get();
            MissingWildsForgeResources.addLog(logData, modCompat.modid());
        }));
        Constants.LOG.info("Generated missing wilds compat for mods: " + ForgeModCompatHandler.modCompats.keySet().stream().filter(Services.PLATFORM::isModLoaded).toList());
        RESOURCE_PACK.addTag(Constants.id("blocks/fallen_logs"), FALLEN_LOGS);
    }

    public static void addLog(LogData logData, String modid) {
        ResourceLocation fallenLogLocation = Constants.id("block/" + modid + "_" + logData.name());
        ResourceLocation fallenLogLocationMossy = Constants.id("block/" + modid + "_" + logData.name() + "_mossy");
        ResourceLocation fallenLogLocationSnowy = Constants.id("block/" + modid + "_" + logData.name() + "_snowy");
        ResourceLocation id = Constants.id(modid + "_" + logData.name());
        String blockState = "{\n  \"variants\": {\n    \"axis=x,cover=none\": {\n      \"model\": \"%1$s\",\n      \"y\": 90\n    },\n    \"axis=y,cover=none\": {\n      \"model\": \"%1$s\",\n      \"x\": 90\n    },\n    \"axis=z,cover=none\": {\n      \"model\": \"%1$s\"\n    },\n    \"axis=x,cover=moss\": {\n      \"model\": \"%2$s\",\n      \"y\": 90\n    },\n    \"axis=y,cover=moss\": {\n      \"model\": \"%1$s\",\n      \"x\": 90\n    },\n    \"axis=z,cover=moss\": {\n      \"model\": \"%2$s\"\n    },\n    \"axis=x,cover=snow\": {\n      \"model\": \"%3$s\",\n      \"y\": 90\n    },\n    \"axis=y,cover=snow\": {\n      \"model\": \"%1$s\",\n      \"x\": 90\n    },\n    \"axis=z,cover=snow\": {\n      \"model\": \"%3$s\"\n    }\n  }\n}\n".replace("%1$s", fallenLogLocation.toString()).replace("%2$s", fallenLogLocationMossy.toString()).replace("%3$s", fallenLogLocationSnowy.toString());
        RESOURCE_PACK.addBlockState(id, blockState.getBytes());
        RESOURCE_PACK.addModel(fallenLogLocation, ModelJsonBuilder.create((String)"missingwilds:block/template/fallen_log_template").addTexture("log", logData.logTexture()).addTexture("log_inner", logData.strippedLogTexture()));
        RESOURCE_PACK.addModel(fallenLogLocationMossy, ModelJsonBuilder.create((String)"missingwilds:block/template/fallen_log_template_mossy").addTexture("log", logData.logTexture()).addTexture("log_inner", logData.strippedLogTexture()));
        RESOURCE_PACK.addModel(fallenLogLocationSnowy, ModelJsonBuilder.create((String)"missingwilds:block/template/fallen_log_template_snowy").addTexture("log", logData.logTexture()).addTexture("log_inner", logData.strippedLogTexture()));
        RESOURCE_PACK.addModel(Constants.id("item/" + modid + "_" + logData.name()), ModelJsonBuilder.create((ResourceLocation)fallenLogLocation));
        FALLEN_LOGS.m_215902_(TagEntry.m_215925_((ResourceLocation)id));
        String recipe = "{\n  \"type\": \"minecraft:crafting_shaped\",\n  \"group\": \"missingwilds:fallen_logs\",\n  \"key\": {\n    \"L\": {\n      \"item\": \"%1$s\"\n    }\n  },\n  \"pattern\": [\n    \"LLL\",\n    \"L L\",\n    \"LLL\"\n  ],\n  \"result\": {\n    \"count\": 8,\n    \"item\": \"%2$s\"\n  }\n}\n".strip().replace("%1$s", logData.blockId()).replace("%2$s", id.toString());
        RESOURCE_PACK.addRecipe(Constants.id(modid + "_" + logData.name()), recipe.getBytes());
        String lootTable = "{\n  \"type\": \"minecraft:block\",\n  \"pools\": [\n    {\n      \"bonus_rolls\": 0.0,\n      \"conditions\": [\n        {\n          \"condition\": \"minecraft:survives_explosion\"\n        }\n      ],\n      \"entries\": [\n        {\n          \"type\": \"minecraft:item\",\n          \"name\": \"%1$s\"\n        }\n      ],\n      \"rolls\": 1.0\n    }\n  ]\n}\n".strip().replace("%1$s", id.toString());
        RESOURCE_PACK.addLootTable(Constants.id(modid + "_" + logData.name()), lootTable.getBytes());
    }
}

